```sh
oneesdocs --help
```

```
Использование
	oneesdocs [опции] [подкомманда] [аргументы]

Подкоманды
	get [таблица] [id] [id2] [id3...]
		Получает и печатает строки таблицы с указаными id в формате json

	find [таблица] [имя поля] [операция] [значение] [имя поля 2] [операция 2] [значение 2]
		Ищет все строки таблицы, в которых значение поля соответствуют условиям,
		все условия должны выполняться одновременно
		печатает id строк, разделённые пробелами

		Возможные операции
			-eq
				значение поля равно данному
			-lt, -gt, -le, -ge
				значение поля меньше больше, меньше либо равно, больше либо равно данному
			-atDay, -atMonth, -atYear
				день, месяц, год даты совпадают с данной датой

	list [таблица]
		Печатает id всех строк таблицы, разделённые пробелами

	listFields [таблица]
		Печатает название и тип всех столбцов таблицы в формате json

	update [таблица] [id] [имя поля] [значение поля] [имя поля 2] [значение поля 2]
		Обновляет данные в таблице. Если строки с заданным id не существует,
		должна вернуться с кодом ошибки 1

	insert [таблица] [имя поля] [значение поля] [имя поля 2] [значение поля 2]
		Добавляет строку с указанными значениями в таблицу, неуказанные поля по считаются пустыми,
		печатает id созданное строки

Опции
	-h, --help
		Показывает это сообщение
```


```sh
oneesdocs get справка1 1 2
```

```json
{
	"result": [
		{
			"id": 1,
			"patient_name": "Пупкину Василию Андреевичу",
			"date_interview": "2024-05-13T00:00:00+03:00",
			"somatic_patology": 0,
			"protivopokazaniya": "",
			"ekg": "",
			"zakluchenie": "Здесь может быть написано длинное заключение,\nна несколько строк\nи даже больше",
			"vrach_terapevt": "Сливочкин Андрей Васильевич"
		},
		{
			"id": 2,
			"patient_name": "Пупкину Илье Александровичу",
			"date_interview": "2024-05-14T00:00:00+03:00",
			"somatic_patology": 1,
			"protivopokazaniya": "",
			"ekg": "",
			"zakluchenie": "",
			"vrach_terapevt": "Сливочкин Андрей Васильевич"
		}
	]
}
```


```sh
oneesdocs find справка1 somatic_patology -eq 0
```

```
1 3 4 10
```


```sh
oneesdocs find справка1 date_interview -ge "2024-05-13T00:00:00+03:00" -lt "2024-05-14T00:00:00+03:00
```

```
1
```


```sh
oneesdocs listFields справка1
```

```json
{
	"table": "справка1",
	"columns": [
		{
			"name": "id",
			"readable_name": "Уникальный идентификатор",
			"type": "INT"
		},
		{
			"name": "patient_name",
			"readable_name": "ФИО пациента",
			"type": "TEXT"
		},
		{
			"name": "date_interview",
			"readable_name": "Дата собеседования",
			"type": "TIMESTAMP"
		},
		{
			"name": "somatic_patology",
			"readable_name": "Соматическая патология",
			"type": "INT"
		},
		{
			"name": "protivopokazaniya",
			"readable_name": "Противопоказания",
			"type": "TEXT"
		},
		{
			"name": "ekg",
			"readable_name": "ЭКГ",
			"type": "TEXT"
		},
		{
			"name": "zakluchenie",
			"readable_name": "Заключение",
			"type": "TEXT"
		},
		{
			"name": "vrach_terapevt",
			"readable_name": "Врач-терапевт",
			"type": "TEXT"
		},
	]
}
```


```sh
oneesdocs insert справка1 patient_name "Пупкину Василию Андреевичу" date_interview "2024-05-13T00:00:00+03:00" somatic_patology 0 protivopokazaniya "" ekg "" zakluchenie "Здесь может быть написано длинное заключение,\nна несколько строк\nи даже больше" vrach_terapevt "Сливочкин Андрей Васильевич"
```

```
11
```
